jQuery(document).ready(function($){

    var $offset = "89%",
        $d = 700,
        $e = 'easeInOutQuad'; //[0.7, 0, 0.3, 1];

    // --------------------------------------------------------------
    // --- WELCOME ANIMATION ---
    // --------------------------------------------------------------

    $('#js-welcome').waypoint({
        handler: function(e) {
            anime({
                targets: this.element.querySelectorAll('.t-anim'),
                translateY: ["150%","50%"],
                opacity: [0, 1],
                easing: $e,
                duration: $d,
                delay: function (el, i, l) { return i * 500; }
            });
        },
        offset: $offset
    });

    var sw_welcome = new Swiper('#js-sw-welcome',{
        effect: 'fade',
        autoHeight: true,
        speed: 2000,
        autoplay: {
            delay: 3000
        }
    });

    // --------------------------------------------------------------
    // --- HIGHLIGHT ANIMATION ---
    // --------------------------------------------------------------

    $('#js-highlight').waypoint({
        handler: function(e) {
            var ani = anime.timeline({
                    autoplay: false,
                    loop: 0
                });

            ani.add({
                targets: "#js-highlight .js-item-0",
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            ani.add({
                targets: "#js-highlight .js-item-1",
                translateY: [-100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            ani.add({
                targets: "#js-highlight .js-item-2",
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            ani.add({
                targets: "#js-highlight .js-item-3",
                translateY: [-100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            ani.add({
                targets: "#js-highlight .js-item-4",
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            if (e == 'down') {
                ani.play();
                if (ani.reversed) ani.reverse();
            } else {
                ani.play();
                if (!ani.reversed) ani.reverse();
            }
        },
        offset: $offset
    });

    // --------------------------------------------------------------
    // --- SOLUTIONS ANIMATION ---
    // --------------------------------------------------------------

    $('#js-sols').waypoint({
        handler: function(e) {

            var t = anime.timeline({
                autoplay: false,
                loop: 0
            });

            t.add({
                targets: '#js-sol-text',
                translateY: [-200,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            t.add({
                targets: '#js-sol-points',
                translateY: [200,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            t.add({
                targets: '#js-sol-title',
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                duration: $d
            });

            if (e == 'down') {
                if (t.reversed) t.reverse();
                t.play();
            } else {
                if (!t.reversed) t.reverse();
                t.play();
            }
        },
        offset: $offset
    });

    var sw_sols = new Swiper('#js-sw-sols',{}),
        ci = $(".c-home-solution__point-item:nth-child(1)");

    $(".js-sol-page").first().addClass('live');
    $("#js-sol-title").text(ci.attr('alt'));

    $("#js-sol-next").click(function(e){
        sw_sols.slideNext();
    });

    sw_sols.on('slideChangeTransitionEnd', function () {
        var c = sw_sols.activeIndex;
            n = parseInt(c) + 1;
            ci = $(".c-home-solution__point-item:nth-child(" + n + ")");

        $(".js-sol-page").removeClass('live');
        $(".c-home-solution__p-icon--" + c).addClass('live');
        $("#js-sol-title").text(ci.attr('alt'));
    });

    $("#js-sol-prev").click(function(e){
        sw_sols.slidePrev();
    });

    $(".js-sol-page").click(function(e){
        var s = $(this).data('slide');
        sw_sols.slideTo(s);
    });

    // --------------------------------------------------------------
    // --- CORE ANIMATION ---
    // --------------------------------------------------------------

    $('#js-core').waypoint({
        handler: function(e) {

            var ani = anime.timeline({
                    autoplay: false,
                    loop: 0
                });

            ani.add({
                targets: '#js-core .js-title',
                translateY: [-200,0],
                opacity: [0, 1],
                easing: $e,
                duration: 700
            });

            ani.add({
                targets: '#js-core .js-item',
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                delay: function (el, i, l) { return i * 300; },
                duration: 700
            });

            if (e == 'down') {
                if (ani.reversed) ani.reverse();
                ani.play();
            } else {
                if (!ani.reversed) ani.reverse();
                ani.play();
            }
        },
        offset: $offset
    });

    // --------------------------------------------------------------
    // --- CORE ANIMATION ---
    // --------------------------------------------------------------

    $('#js-core-b').waypoint({
        handler: function(e) {

            var ani = anime.timeline({
                    autoplay: false,
                    loop: 0
                });

            ani.add({
                targets: "#js-core-b .js-item-0",
                translateX: [-120,0],
                opacity: [0,1],
                easing: $e,
                duration: 700
            });

            ani.add({
                targets: "#js-core-b .js-item-1",
                translateX: [120,0],
                opacity: [0,1],
                easing: $e,
                duration: 700,
                offset: "-=700"
            });

            if (e == 'down') {
                if (ani.reversed) ani.reverse();
                ani.play();
            } else {
                if (!ani.reversed) ani.reverse();
                ani.play();
            }
        },
        offset: $offset
    });

    var sw_core_pics = new Swiper('#js-sw-core-pics', {
        pagination: {
            el: '#js-core-pager',
            type: 'bullets',
        }
    });

    var sw_core_text = new Swiper('#js-sw-core-text', {
        effect: 'fade',
        autoHeight: true
    });

    $("#js-core-prev").click(function(e){
        sw_core_pics.slidePrev();
    });

    $("#js-core-next").click(function(e){
        sw_core_pics.slideNext();
    });

    sw_core_pics.on('slideChangeTransitionEnd', function () {
        var i = sw_core_pics.activeIndex;
        sw_core_text.slideTo(i);
    });

    // --------------------------------------------------------------
    // --- BUSINESS ANIMATION ---
    // --------------------------------------------------------------

    $('#js-busi').waypoint({
        handler: function(e) {

            var ani = anime.timeline({
                    autoplay: false,
                    loop: 0
                });

            ani.add({
                targets: this.element.querySelectorAll('.js-title'),
                translateY: [-200,0],
                opacity: [0, 1],
                easing: $e,
                duration: 700
            });

            ani.add({
                targets: this.element.querySelectorAll('.js-item'),
                translateY: [200,0],
                opacity: [0, 1],
                easing: $e,
                delay: function (el, i, l) { return i * 400; },
                duration: 700,
                offset: "-=500"
            });

            if (e == 'down') {
                if (ani.reversed) ani.reverse();
                ani.play();
            } else {
                if (!ani.reversed) ani.reverse();
                ani.play();
            }
        },
        offset: $offset
    });

    var sw_overlay = new Swiper('#js-sw-overlay',{}),
        ot = anime.timeline({
            autoplay: false,
            loop: 0,
            begin: function(a){
                if(!$("#js-overlay").hasClass('active')) $("#js-overlay").addClass('active');
            },
            complete: function(a){
                if(this.reversed) $("#js-overlay").removeClass('active');
            }
        });

    ot.add({
        targets: '#js-overlay',
        translateY: ["-100%",0],
        easing: $e,
        duration: $d
    });

    ot.add({
        targets: '#js-overlay .js-overlay-img',
        translateX: [-100,0],
        opacity:[0,1],
        easing: $e,
        duration: $d,
        offset: 800
    });

    ot.add({
        targets: '#js-overlay .js-overlay-text',
        translateX: [100,0],
        opacity:[0,1],
        easing: $e,
        duration: $d,
        offset: 1100
    });

    $(".js-business-trig").click(function(e){
        e.preventDefault();
        var o = $(this).data('overlay');
        sw_overlay.slideTo(o, 0);
        ot.play();
        if (ot.reversed) ot.reverse();
    });

    $("#js-sw-overlay-next").click(function(e){
        sw_overlay.slideNext();
    });

    $("#js-sw-overlay-prev").click(function(e){
        sw_overlay.slidePrev();
    });

    $(".js-close-overlay").click(function(e){
        ot.play();
        if (!ot.reversed) ot.reverse();
    });

    // --------------------------------------------------------------
    // --- RANGE ANIMATION ---
    // --------------------------------------------------------------

    $('#js-range').waypoint({
        handler: function(e) {

            var ani = anime.timeline({
                autoplay: false,
                loop: 0
            });

            ani.add({
                targets: this.element.querySelectorAll('.js-title'),
                translateY: [-200,0],
                opacity: [0, 1],
                easing: $e,
                duration: 700
            });

            ani.add({
                targets: this.element.querySelectorAll('.js-item'),
                translateY: [200,0],
                opacity: [0, 1],
                delay: function (el, i, l) { return i * 400; },
                easing: $e,
                duration: 700,
                offset: "-=500"
            });

            if (e == 'down') {
                if (ani.reversed) ani.reverse();
                ani.play();
            } else {
                if (!ani.reversed) ani.reverse();
                ani.play();
            }
        },
        offset: $offset
    });

    $(".js-trig").click(function(e){
        var $d = $(this).data('detail');
        $(".js-detail").removeClass('is-active');
        $("#" + $d).addClass('is-active');
        $("#js-wrap").addClass('c-home-range__wrap--opened');

        anime({
            targets: ".is-active .js-range-detail",
            translateX: [100,0],
            opacity: [0,1],
            delay: 400,
            duration: 500,
            easing: $e
        });
    });

    $(".js-close").click(function(e){
        $("#js-wrap").removeClass('c-home-range__wrap--opened');
    });

    // --------------------------------------------------------------
    // --- BUSINESS ANIMATION ---
    // --------------------------------------------------------------

    $('#js-pre').waypoint({
        handler: function(e) {

            var ani = anime.timeline({
                    autoplay: false,
                    loop: 0
                });

            ani.add({
                targets: this.element.querySelectorAll('.js-title'),
                translateY: [-200,0],
                opacity: [0, 1],
                easing: $e,
                duration: 700
            });

            ani.add({
                targets: this.element.querySelectorAll('.js-item'),
                translateY: [100,0],
                opacity: [0, 1],
                easing: $e,
                delay: function (el, i, l) { return i * 200; },
                duration: 700,
                offset: "-=500"
            });

            if (e == 'down') {
                if (ani.reversed) ani.reverse();
                ani.play();
            } else {
                if (!ani.reversed) ani.reverse();
                ani.play();
            }
        },
        offset: $offset
    });

    // --------------------------------------------------------------
    // --- THAI ANIMATION ---
    // --------------------------------------------------------------

    var jt = $('#js-thai').waypoint({
        handler: function(e) {

            var tt = anime.timeline({
                loop: 0,
                autoplay: false
            });

            tt.add({
                targets: '#js-thai-wrap',
                scale: [.5,1],
                easing: $e,
                duration: 700
            });

            tt.add({
                targets: '#js-thai-wrap .js-item',
                translateY: [200,0],
                opacity: [0, 1],
                easing: $e,
                delay: function (el, i, l) { return i * 300; },
                duration: 700
            });

            tt.play();
            this.disable();
        },
        offset: "50%"
    });

});
