<?php
/**
 * The header template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Site
 */ ?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
        <meta name="description" content="Farm to plate is your food innovation and development partner based out of Bangkok providing end to end solutions to its clients"/>
        <meta name="keywords" content="Food technology,solutions,innovation,global,market trends,consumer insight,technology partners,concept,development cell,food tech innovation,food product development,ideas,creative solutions,Thailand, kitchen of the world,manufacturing technology,new product development,commercialization,process control,food technology experts"/>
		<meta property="og:locale" content="en_US" />
		<meta property="og:type" content="website" />
		<meta property="og:title" content="Farm To Plate - Food Technology Solutions" />
		<meta property="og:description" content="Farm to plate is your food innovation and development partner based out of Bangkok providing end to end solutions to its clients" />
		<meta property="og:url" content="https://interdigitel.com/f2p/" />
		<meta property="og:site_name" content="Farm To Plate" />
		<meta name="twitter:card" content="summary_large_image" />
		<meta name="twitter:description" content="Farm to plate is your food innovation and development partner based out of Bangkok providing end to end solutions to its clients" />
		<meta name="twitter:title" content="Farm To Plate - Food Technology Solutions" />
        <?php wp_head(); ?>
        <!--[if lt IE 9]>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js"></script>
            <script>window.html5 || document.write('<script src="<?php echo get_template_directory_uri() ?>/js/vendor/html5shiv.js"><\/script>')</script>
        <![endif]-->
    </head>
    <body <?php body_class(); ?>>

        <!--[if lt IE 8]>
            <div class="c-browser-upgrade">
                You are using an <strong>outdated</strong> browser.
                Please <a href="http://browsehappy.com/">upgrade your browser</a>
                to improve your experience.
            </div>
        <![endif]-->

		<header class="c-site-header" id="js-header">
			<div class="o-container c-site-header__container">

				<div class="c-site-header__logo">
					<h1><?php the_custom_logo(); ?></h1>
				</div>

				<nav class="c-site-header__nav">
					<div class="c-site-header__nav-wrap">

						<ul class="c-site-header__menu">
							<?php wp_nav_menu( array(
								'theme_location' => 'site_header_menu',
								'container' => false,
								'items_wrap' => '%3$s'
							)); ?>
						</ul>

					</div>
                </nav>

                <button class="c-site-header__ham" id="js-nav-trig"><span></span></button>
                <div class="c-site-header__shade" id="js-nav-shade"></div>

			</div>
		</header>
		<main class="c-site-wrap">
