<?php

// ---------------------------------------------------------------------
// -- Customize ACF path --
// ---------------------------------------------------------------------

add_filter('acf/settings/path', 'my_acf_settings_path');
function my_acf_settings_path( $path ) {
    $path = get_stylesheet_directory() . '/inc/vendor/acf/';
    return $path;
}

// ---------------------------------------------------------------------
// -- Customize ACF dir --
// ---------------------------------------------------------------------

add_filter('acf/settings/dir', 'my_acf_settings_dir');
function my_acf_settings_dir( $dir ) {
    $dir = get_stylesheet_directory_uri() . '/inc/vendor/acf/';
    return $dir;
}

// ---------------------------------------------------------------------
// -- Hide ACF field group menu item --
// ---------------------------------------------------------------------

//add_filter('acf/settings/show_admin', '__return_false');

// ---------------------------------------------------------------------
// -- Include ACF --
// ---------------------------------------------------------------------

include_once( get_stylesheet_directory() . '/inc/vendor/acf/acf.php' );

// ---------------------------------------------------------------------
// -- Create Option Pages --
// ---------------------------------------------------------------------

if( function_exists('acf_add_options_page'))
{
    acf_add_options_page(array(
        'page_title'    => __('Theme Options','site'),
        'menu_title'    => __('Options','site'),
        'menu_slug'     => 'site-options',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));
}
