<?php

// --------------------------------------------------------------------------------
// -- PORTFOLIO --
// --------------------------------------------------------------------------------

function abhije_portfolio_function()
{
    $out = "";
    $posts = get_posts('post_type=project&posts_per_page=-1&orderby=menu_order&order=asc');
    if( count( $posts ) > 0 )
    {
        $i = 0;
        $out .= '<div class="c-projects">';
        foreach( $posts as $p )
        {
            if( count($posts) != 0 )
            {
                $out .= '<div class="o-table c-projects__table">';
                $out .= '<div class="o-table__wrap c-projects__wrap">';
                $ps   = array_splice( $posts, 0, 3 );
                foreach( $ps as $po )
                {
                    $src     = get_the_post_thumbnail_url( $po->ID, 'large' );
                    $des     = get_post_meta( $po->ID, 'project__designer', true );
                    $des_url = get_post_meta( $po->ID, 'project__designer_url', true );

                    $out .= '<div class="o-table__col c-projects__col">';
                    $out .= '<div class="c-projects__bg" style="background-image:url(' . $src . ');"></div>';
                    $out .= '<article class="c-projects__post">';
                    $out .= '<h5>' . $po->post_title . '</h5>';

                    if($des)
                    {
                        $out .= '<p class="c-projects__des"><a target="_blank" href="' . $des_url . '">';
                        $out .= 'Designed by ' . $des;
                        $out .= '</a></p>';
                    }

                    $out .= apply_filters( 'the_content', $po->post_content );
                    $out .= '<div class="o-btn__group">';
                    $out .= '<a class="o-btn o-btn--sm" target="_blank" href="' . get_permalink($po->ID) . '">';
                    $out .= 'Visit Website</a>';
                    $out .= '</div>';
                    $out .= '</article>';
                    $out .= '</div>';
                }

                $out .= '</div>';
                $out .= '</div>';
            }
        }

        $out .= '</div>';
    }

    return $out;
}

// --------------------------------------------------------------------------------
// -- REGISTER SHORTCODES --
// --------------------------------------------------------------------------------

function register_shortcodes()
{
   add_shortcode('abhije-portfolio', 'abhije_portfolio_function');
}

// --------------------------------------------------------------------------------
// -- HOOK INTO WORDPRESS --
// --------------------------------------------------------------------------------

add_action( 'init', 'register_shortcodes');
