<?php
/**
 * The page template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Site
 */

get_header();
while( have_posts() ) : the_post();
    $f_img = get_the_post_thumbnail_url(); ?>

    <section class="c-page-header" style="background-image:url('<?php echo $f_img; ?>');">
        <article class="c-page-header__post">
            <div class="o-container">
                <h1><?php the_title() ?></h1>
                <?php edit_post_link() ?>
            </div>
        </article>
    </section>

	<section class="c-page-content c-page-content--<?php echo $post->post_name ?>">
		<div class="o-container o-container--no-spacing">
            <article class="o-post t-anim" data-entrance="from-bottom">
                <?php the_content() ?>
            </article>
		</div>
	</section><?php

    $section = get_field('site_about_detail');
    if(is_array($section)) : ?>

        <section class="c-page-content c-page-content--about-0">
            <div class="o-container">
                <div class="o-table">
                    <div class="o-table__wrap">
                        <div class="o-table__col">
                            <article class="o-post t-anim" data-entrance="from-bottom">
                                <?php echo apply_filters('the_content', $section['primary']) ?>
                            </article>
                        </div>
                        <div class="o-table__col">
                            <article class="o-post t-anim" data-entrance="from-bottom">
                                <?php echo apply_filters('the_content', $section['secondary']) ?>
                            </article>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="c-page-content c-page-content--about-1">
            <div class="o-container">
                <article class="o-post c-page-content--secondary t-anim" data-entrance="from-bottom">
                    <?php echo apply_filters('the_content', $section['tertiary']) ?>
                </article>
            </div>
        </section><?php

        $section = get_field('site_about_roles');
        if(is_array($section)) : ?>
            <section class="c-page-content c-page-content--about-2">
                <div class="o-container">

                    <article class="o-post c-page-content--secondary t-anim" data-entrance="from-bottom"><?php
                        echo apply_filters('the_content', $section['content']); ?>
                    </article><?php

                    if(is_array($section['points'])) : $d = 0; ?>
                        <div class="c-page-content__points"><?php
                            foreach( $section['points'] as $p ) : ?>
                                <div class="c-page-content__point t-anim"
                                    data-entrance="from-bottom" data-entrance-delay="<?php echo $d ?>">
                                    <img src="<?php echo $p['icon'] ?>" alt="i">
                                    <p><?php echo $p['title'] ?></p>
                                </div><?php
                                $d += 250;
                            endforeach; ?>
                        </div><?php
                    endif ?>

                </div>
            </section><?php
        endif;

    endif;
endwhile;
get_footer();
